<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Forfaits extends Model 
{

    protected $table = 'forfaits';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function achats()
    {
        return $this->hasMany('App\Models\Achat');
    }

    public function matieres()
    {
        return $this->belongsToMany('App\Models\Matiere');
    }

}